package centrocommerciale;

/**
 * Riceve i singoli parametri dalla CommercialFactory e colcola il singolo
 * guadagno
 * 
 * @author koelio
 * @parameter earnings guadagni singoli per l'Attività
 * 
 */
public class Service extends Commercial {

	double earnings;
	double fixedcosts;
	double mqPrice;

	public Service(String id, String type, int localNumb, int mqTot,int costs, int income) {
		super(id, type, localNumb, mqTot, income);

		if (mqTot >= 140) {
			mqPrice = mqTot * 7 + mqTot * 8;
		} else {
			mqPrice = mqTot * 16;
		}

		this.earnings = income - (mqPrice + costs);

		System.out.println(id + " " + earnings);

	}

	@Override
	public double getEarnings() {

		return earnings;
	}

}
